# Opus – Personalized Wallpapers from Your Apple Music Library

**Opus** is a beautifully designed iOS app that transforms your Apple Music listening history into dynamic, personalized wallpapers.

---

## ✨ What It Does

Opus generates music wallpapers from users' Apple Music library using a variety of unique and expressive layouts. Album artwork is arranged in styles such as grids, vinyl records, and color discs, and each wallpaper reflects the user’s listening habits and personal taste.

---

## 📱 Key Features

- **Wallpaper from Music**: Generate wallpapers using your most played, recently played, or saved (playlisted) albums from Apple Music.
- **Multiple Styles**: Choose from visually distinct layouts including grids, vinyl records, and colorful discs.
- **Shortcuts Integration**: Automate your wallpaper to update daily or on demand using Apple’s Shortcuts app.
- **iOS-Native Design**: Opus was designed specifically for iOS with a clean, intuitive interface and smooth performance.
- **Opus Premium**: Unlock additional styles and automation features with an optional subscription or one-time purchase.

> Note: Opus currently supports **Apple Music only** and does not yet integrate with other streaming services.

---

## 🚀 About the Developer

Hey, I'm Jack Minehan. I’m an independent developer focused on creating thoughtful, iOS-native apps that integrate seamlessly with Apple technologies. Opus is built with care to feel perfectly at home in the Apple ecosystem: simple, expressive, and a little magical.

---

## 📷 Included Assets

- App Icon (`AppIcon.png`)
- Framed iPhone Screenshots of Each Wallpaper (and the App UI)
- This README (`README.md`) / PDF version

---

## 📬 Contact & Links

- **App Store Link**: [https://apps.apple.com/app/id6745432548](https://apps.apple.com/app/id6745432548)
- **Website**: [https://opusapp.vercel.app](https://opusapp.vercel.app)
- **Privacy Policy**: [https://opusapp.vercel.app/privacy.html](https://opusapp.vercel.app/privacy.html)
- **Terms of Use**: [https://opusapp.vercel.app/terms.html](https://opusapp.vercel.app/terms.html)
- **Contact**: jackminehandev@gmail.com
- **Mastodon**: [jackminehan@mastodon.social](https://mastodon.social/@jackminehan)

---

Thanks for reading!